// src/js/strict.js
(function () {
  const rows = Array.from(document.querySelectorAll('#tableStrict tbody tr'));
  if (!rows.length) return;

  // Récupère labels + valeurs nettoyées
  const labels = rows.map(r => r.cells[0].textContent.trim());
  const values = rows.map(r => {
    let n = r.cells[1].textContent.trim().replace(',', '.');
    return Number(n);
  });

  const canvas = document.getElementById('chartStrict');
  const ctx = canvas.getContext('2d');

  // Petit gradient propre
  const gradient = ctx.createLinearGradient(0, 0, 0, 350);
  gradient.addColorStop(0, 'rgba(14, 165, 233, .25)');
  gradient.addColorStop(1, 'rgba(14, 165, 233, 0)');

  new Chart(ctx, {
    type: 'line',
    data: {
      labels: labels,
      datasets: [{
        label: 'Consommation (TWh)',
        data: values,
        tension: 0.25,
        pointRadius: 4,
        borderWidth: 2,
        borderColor: 'rgb(14,165,233)',
        backgroundColor: gradient,
        fill: true
      }]
    },
    options: {
      responsive: true,
      maintainAspectRatio: true,
      plugins: {
        legend: { display: true },
        tooltip: { mode: 'index', intersect: false }
      },
      scales: {
        x: {
          title: { text: 'Année', display: true }
        },
        y: {
          title: { text: 'TWh', display: true },
          beginAtZero: false,
          ticks: { callback: v => v + '' }
        }
      }
    }
  });
})();
